/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.core.Device;
import jace.core.VideoWriter;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public abstract class Video
extends Device {
    BufferedImage video = new BufferedImage(560, 192, 1);
    VideoWriter currentWriter;
    Graphics screen;
    private byte floatingBus = 0;
    private int width = 560;
    private int height = 192;
    private int x = 0;
    protected int y = 0;
    public static int CYCLES_PER_LINE;
    public static int TOTAL_LINES;
    public static int APPLE_CYCLES_PER_LINE;
    public static int APPLE_SCREEN_LINES;
    public static int HBLANK;
    public static int VBLANK;
    int vPeriod = 0;
    int hPeriod = 0;
    static int[] textOffset;
    static int[] hiresOffset;
    protected static int[] textRowLookup;
    protected static int[] hiresRowLookup;
    private boolean screenDirty = true;
    static VideoWriter[][] writerCheck;

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    public void setScreen(Graphics g) {
        this.screen = g;
    }

    public VideoWriter getCurrentWriter() {
        return this.currentWriter;
    }

    public void setCurrentWriter(VideoWriter currentWriter) {
        this.currentWriter = currentWriter;
    }

    protected abstract void vblankStart();

    protected abstract void vblankEnd();

    public void tick() {
        if (this.vPeriod > 0) {
            --this.vPeriod;
            if (this.vPeriod == 0) {
                this.vblankEnd();
            }
        } else if (this.hPeriod > 0) {
            --this.hPeriod;
            if (this.hPeriod == 0) {
                ++this.y;
                if (this.y >= 192) {
                    this.updateScreen();
                    this.vblankStart();
                    this.vPeriod = VBLANK;
                    this.y = 0;
                }
            }
        } else {
            this.draw();
            ++this.x;
            if (this.x >= 40) {
                this.currentWriter.clearDirty(this.y);
                this.hPeriod = HBLANK;
                this.x = 0;
            }
        }
    }

    public abstract void configureVideoMode();

    protected static int byteDoubler(byte b) {
        int num = (b & 0x40) << 6 | (b & 0x20) << 5 | (b & 0x10) << 4 | (b & 8) << 3 | (b & 4) << 2 | (b & 2) << 1 | b & 1;
        return num | num << 1;
    }

    private void draw() {
        int wait;
        if (this.writerChanged(this.x, this.y) || this.currentWriter.isRowDirty(this.y)) {
            this.screenDirty = true;
            this.currentWriter.displayByte(this.video, this.x, this.y, textOffset[this.y], hiresOffset[this.y]);
        }
        if ((wait = this.currentWriter.getWaitCycles()) > 0) {
            this.x += wait;
            this.setWaitCycles(wait);
            if (this.x < 40) {
                this.writerChanged(this.x, this.y);
            }
        }
        this.doPostDraw();
    }

    public static int calculateHiresOffset(int y) {
        return Video.calculateTextOffset(y >> 3) + ((y & 7) << 10);
    }

    public static int calculateTextOffset(int y) {
        return ((y & 7) << 7) + 40 * (y >> 3);
    }

    public static int identifyTextRow(int y) {
        return (y >> 7) + ((y & 0x7F) / 40 << 3);
    }

    public static int identifyHiresRow(int y) {
        int blockOffset = Video.identifyTextRow(y & 0x3FF);
        if (blockOffset > 23) {
            return -1;
        }
        return (y >> 10 & 7) + (blockOffset << 3);
    }

    public abstract void doPostDraw();

    private void updateScreen() {
        if (this.screenDirty) {
            this.screen.drawImage(this.video, 0, 0, this.width, this.height, null);
        }
        this.screenDirty = false;
    }

    public byte getFloatingBus() {
        return this.floatingBus;
    }

    public void setFloatingBus(byte floatingBus) {
        this.floatingBus = floatingBus;
    }

    private boolean writerChanged(int x, int y) {
        if (writerCheck[x][y] == this.currentWriter.actualWriter()) {
            return false;
        }
        Video.writerCheck[x][y] = this.currentWriter.actualWriter();
        return true;
    }

    public void markDirty() {
        this.screenDirty = true;
    }

    static {
        int i;
        CYCLES_PER_LINE = 65;
        TOTAL_LINES = 262;
        APPLE_CYCLES_PER_LINE = 40;
        APPLE_SCREEN_LINES = 192;
        HBLANK = CYCLES_PER_LINE - 40;
        VBLANK = (TOTAL_LINES - APPLE_SCREEN_LINES) * CYCLES_PER_LINE;
        writerCheck = new VideoWriter[40][192];
        textOffset = new int[192];
        hiresOffset = new int[192];
        textRowLookup = new int[1024];
        hiresRowLookup = new int[8192];
        for (i = 0; i < 192; ++i) {
            Video.textOffset[i] = Video.calculateTextOffset(i >> 3);
            Video.hiresOffset[i] = Video.calculateHiresOffset(i);
        }
        for (i = 0; i < 1024; ++i) {
            Video.textRowLookup[i] = Video.identifyTextRow(i);
        }
        for (i = 0; i < 8192; ++i) {
            Video.hiresRowLookup[i] = Video.identifyHiresRow(i);
        }
    }
}

